*-------------------------------------------------------------------------------
/* title : Program to estimate and store relevant parameters for original and 
		   bootstrap sample, and bootstrapped standard errors
   input : $temp/Sample.dta;  and relevant code to estimate production function
		   $code/[4.2_sub] pf_estimation_${model}.do
   output: $output_dta/ .dta files store bootstrap point estimates 
		   $output_dta/ .ster files store estimation results */
*-------------------------------------------------------------------------------

*-------------------PROGRAM FOR PRODUCTION FUNCTION ESTIMATION------------------
global rep = 0 											// Initialise # of bootstrap replication: 0 for original sample; >0 for any bootstrap sample

program drop _all
program $model, eclass
	tempname b
	
	* Production function estimation 
	run "$code/[4.2_sub] pf_estimation_${compet}.do" 	// 1st Step: Non Linear Least Square of share equation; and 2nd Step: GMM of remaining pf parameters

	ereturn clear
	global rep = $rep + 1 								// Increment # of bootstrap replications: 0 for original sample; >0 for any bootstrap sample
	
	* Declare relevant parameters stored when bootstraping
	qui foreach var in omega $markov J {
		* Rename certain regressors stored in the bootstrap below 
		* (convenient for exporting row names of regression tables)
		local fix = subinstr("`var'", "_00", "", .) 	// Drop the _00 ending
		local fix = subinstr("`fix'", "broad", "", .) 	// Drop the broad part
		local fix = subinstr("`fix'", "0d", "", .) 		// Drop the 0d part
		local fix = subinstr("`fix'", "_dvlpd", "", .) 	// Drop the _dvlpd ending
		
		* Store estimated parameter values
		sum rho_`var', mean
		ereturn scalar `fix' = r(mean)
	}
	
	* Housekeeping (safeguard bootstrap from crashing)
	drop a_* rho* *omega* RTS*
	cap drop markup sigma 								// Additional variables for Imperfect Competition (IC)
end

*-----------------------------BOOTSTRAP PROCEDURE-------------------------------

* Declare relevant parameters stored when bootstraping
foreach var in omega $markov J {
	* Rename certain regressors stored in the bootstrap below 
	* (convenient for exporting row names of regression tables)
	local fix = subinstr("`var'", "_00", "", .) 		// Drop the _00 ending
	local fix = subinstr("`fix'", "broad", "", .) 		// Drop the broad part
	local fix = subinstr("`fix'", "0d", "", .) 			// Drop the 0d part
	local fix = subinstr("`fix'", "_dvlpd", "", .) 		// Drop the _dvlpd ending
 	local results `results' `fix' = e(`fix')
}

* Bootstrap (also save estimates from each bootstraped sample)
noi bootstrap "`results'", saving("$output_dta/$model",replace) seed($seed) reps($B) cluster($clust) idcluster($idclust) group($group) nowarn: $model

*-----------------------------SAVE ESTIMATION RESULTS---------------------------
estimates save "$output_dta/$model", replace 			// Save results in .ster file and call back any time for constructing result tables
